from typing import List
from abc import ABC, abstractmethod

from bpy.types import Object, ShaderNodeGroup

from mesh_storage import MeshStorage
from serializer import SLink, SInput
from pyedm_platform_selector import pyedm
from materials.material_wrap import MaterialWrap
from custom_sockets import TransparencyEnumItems

## base material class 
class IMaterial(ABC):
    """
    Common abstract class for all types of materials.
    """

    ## Material name. Look at 'NodeGroupTypeEnum' to see all possible materials.
    name: str = NotImplemented
    ## Relative path to .pickle file of serialised material.
    description_file_name: str = NotImplemented
    ## material wrapper of current material
    factory = NotImplemented
 
    @classmethod
    @abstractmethod
    def build_blocks(cls, obj: Object, wrap: MaterialWrap, storage: MeshStorage) -> pyedm.IRenderNode:
        """
        Create render node that can be imported to edm. 
        Once 'pyedm.IRenderNode' was created, you need to set control node to it and add render node to model. 
        """
        pass

    @classmethod
    @abstractmethod
    def process_links(cls, links: List[SLink], version: int, group_node_type_name: str)-> List[SLink]:
        pass

    @classmethod
    @abstractmethod
    def restore_defaults(cls, old_sockest: List[SInput], 
                         new_node_group: ShaderNodeGroup, old_version: int, material_name: str) -> None:
        pass

#-------------------------------------------------------------------------------------------------------------------
##  additional material methods 

def get_transparency_value(transparency_value) -> int:
    if transparency_value == TransparencyEnumItems[0][0]:
        return 0
    elif transparency_value == TransparencyEnumItems[1][0]:
        return 1
    elif transparency_value == TransparencyEnumItems[2][0]:
        return 2
    elif transparency_value == TransparencyEnumItems[3][0]:
        return 3
    elif transparency_value == TransparencyEnumItems[4][0]:
        return 3
    elif transparency_value == TransparencyEnumItems[5][0]:
        return 6
    else:
        return 0
